#include <iostream.h>

#include "twister.h"

int main(int argc, char **argv)
{
  // A silly way to construct S^3.

  // General remark: Most versions of SnapPea refuse
  // to think about this triangulation of S^3.  The
  // simplification routines reduce the triangulation
  // down to a single tetrahedron.  Then the function
  // this_way_works in the file simplify_triangulation.c
  // returns an error.  This behavior can be altered.
  // Ask Saul at saul@math.uic.edu for a copy of Jeff
  // Week's patch.  (Unix only.)

  manifold M("S3");

  square s(M);

  // Creating a rectangle of length one actually has no effect, so
  // these next two lines could be omitted without any effect.
  // (Checked 2006/07/11.)

  rectangle x(+s);
  rectangle y(-s);

  M.capoff();

  M.snap_print(cout);
}
