#include <iostream.h>
#include <string.h>

#include "twister.h"

int main(int argc, char **argv)
{
  // Code for generating once punctured torus bundles.  
  // Takes a command line argument of a word in aAbB.

  if (argc != 2)
  {
    cout << "Please specify a monodromy";
    cout << " in the letters 'a', 'A', 'b', 'B'" << endl;
    return 1;
  }

  manifold M(argv[1]);

  square ab(M), bx(M);

  ab.closeup();
  bx.closeup();

  // Intersection graph:
  //
  // a
  // |
  // b-x
  //

  annulus a(+ab);
  annulus b(-ab >> +bx);
  rectangle x(-bx);

  M.capoff(); 

  // Remark: the Dehn twist along 
  // a acts on homology via ( 1, -1 )
  //                        ( 0,  1 )
  // while b acts via ( 1, 0 )
  //                  ( 1, 1 ).
  // So a^{-1}b (= Ab) should give the figure 
  // eight knot complement.
  
  for( int i = 0; argv[1][i] != 0; i++ )
  {
    if( argv[1][i] == 'a' )
      a.twist(plus);
    if( argv[1][i] == 'A' )
      a.twist(minus);
    if( argv[1][i] == 'b' )
      b.twist(plus);
    if( argv[1][i] == 'B' )
      b.twist(minus);
  }

  M.snap_print(cout);
}
