#include <iostream.h>

#include "twister.h" 

int main(int argc, char **argv)
{
  manifold M("Whitehead_link"); 

  // A triangulation of the Whitehead link complement
  // arising from a genus two Heegaard diagram.

  square s[4] = {square(M), square(M),
                 square(M), square(M)};

  annulus a(-s[0] >> +s[1] >> +s[2] >> -s[3]);
  annulus b(+s[0] >> +s[3] >> -s[1] >> -s[2]);

  a.twohandle(above); 
  b.twohandle(below);

  M.capoff();

  M.snap_print(cout);
}
