#include <iostream.h>

#include "twister.h"

int main(int argc, char **argv)
{
  // Triangulation of the figure eight knot
  // complement coming from a genus two Heegaard
  // diagram.

  manifold M("Heeg_split_of_figure_8");

  square s[10] = {square(M), square(M),
                  square(M), square(M), square(M),
                  square(M), square(M), square(M),
                             square(M), square(M)};

  annulus a(+s[0] >> -s[1] >> +s[2] >> -s[3] >> +s[4]);
  annulus b(-s[5] >> +s[6] >> -s[7] >> +s[8] >> -s[9]);
  annulus c(-s[0] >> +s[7] >> -s[4] >> -s[6] >> +s[1] >>
            +s[9] >> -s[2] >> +s[5] >> +s[3] >> -s[8]);

  a.twohandle(above);
  b.twohandle(above);

  c.twohandle(below);

  M.capoff();

  M.snap_print(cout);
}
