#include <iostream.h>
#include <string.h>

#include "twister.h"

const int GENCOUNT=14;  // number of generators
                        // abcdefghijklmn ABCDEFGHIJKLMN

bool badword(char *wordstring)
{
  char c;

  // for as long as wordstring[i] is nonzero
  for (int i=0; c = wordstring[i]; i++)
    if (    (c < 'a' || c > 'a' + GENCOUNT - 1)
         && (c < 'A' || c > 'A' + GENCOUNT - 1)  )
      return true;

  return false;
}

int main(int argc, char **argv)
{
  char *name;

  if (argc <= 1)
  {
    name = "Trivial_Bundle";
  }
  else
  {
    name = argv[1];

    if( argc > 2 || badword(name) )
    {
      cout << "Format: " << endl;
      cout << argv[0] << " [";
      for (int i=0; i<GENCOUNT; i++)
        cout << (char) ('a' + i);
      for (int i=0; i<GENCOUNT; i++)
        cout << (char) ('A' + i);
      cout << "]*" << endl;
      return 1;  // exit with non-zero status
    }
  }

  manifold M(name);

  square s[GENCOUNT-1] = {square(M), square(M), square(M),
                          square(M), square(M), square(M),
                          square(M), square(M), square(M),
                          square(M), square(M), square(M),
                          square(M)};

  for (int i=0; i<GENCOUNT-1; i++)
  {
    s[i].closeup();
  }

  //  Intersection graph of curves:
  //
  //  a       e       h       k       n
  //  |       |       |       |       |
  //  |0      |3      |6      |9      |12
  //  |       |       |       |       |
  //  b---c---d---f---g---i---j---l---m
  //    1   2   4   5   7   8   10  11
  //

  annulus a[GENCOUNT] =
  {
    annulus(+s[0]),                      // a
    annulus(-s[0] >>  +s[1]),            // b
    annulus(-s[1] >>  +s[2]),            // c
    annulus(-s[2] >>  +s[3] >>  +s[4]),  // d
    annulus(-s[3]),                      // e
    annulus(-s[4] >>  +s[5]),            // f
    annulus(-s[5] >>  +s[6] >>  +s[7]),  // g
    annulus(-s[6]),                      // h
    annulus(-s[7] >>  +s[8]),            // i
    annulus(-s[8] >>  +s[9] >>  +s[10]), // j
    annulus(-s[9]),                      // k
    annulus(-s[10] >> +s[11]),           // l
    annulus(-s[11] >> +s[12]),           // m
    annulus(-s[12])                      // n
  };

  M.capoff();


  if (argc <= 1)
    name = "";    // Empty word for trivial bundle

  for( int i = 0; name[i]; i++ )  // until name[i] == \000
  {
    if(name[i] >= 'a' && name[i] < 'a' + GENCOUNT)
      a[name[i] - 'a'].twist(plus);
    else                   // must be capital letter
      a[name[i] - 'A'].twist(minus);
  }
  
  M.snap_print(cout);
}

