#include <iostream.h>
#include <string.h>

#include "twister.h"  // global manifold M

int main(int argc, char **argv)
{
  // Code for generating genus three
  // surface bundles over S^1.
  // As usual, optional argument gives
  // Heegaard splitting instead.

  char *name;

  if( argc == 1 )
  {
    name = "Trivial_Bundle";
  }
  else
  {
    name = argv[1];
  }

  manifold M(name);

  square s[7] = {square(M), square(M), square(M),
                 square(M), square(M), square(M),
                 square(M)};

  // Intersection graph of curves:
  //
  //   a   e   h
  //   0   6   5
  //   b1c2d3f4g
  // 

  annulus a(+s[0]);
  annulus b(-s[0] >> +s[1]);
  annulus c(-s[1] >> +s[2]);
  annulus d(-s[2] >> +s[6] >> +s[3]);
  annulus f(-s[3] >> +s[4]);
  annulus g(-s[4] >> +s[5]);
  annulus h(-s[5]);
  annulus e(-s[6]);

  if( argc > 2 ) // make a Heegaard splitting.
  {
    a.twohandle(below); 
    e.twohandle(below); 
    h.twohandle(below); 
    b.twohandle(above); 
    d.twohandle(above); 
    g.twohandle(above); 
  }
  else            // make a surface bundle.
  {
    for (int i=0; i<7; i++)
      s[i].closeup();
  }

  M.capoff();

  if( argc == 1 )
  { 
    M.snap_print(cout);
    return 0;
  }

  for( int i = 0; argv[1][i] != '\000'; i++ )
  {
    if( argv[1][i] == 'a' )
      a.twist(plus);
    if( argv[1][i] == 'A' )
      a.twist(minus);
    if( argv[1][i] == 'b' )
      b.twist(plus);
    if( argv[1][i] == 'B' )
      b.twist(minus);
    if( argv[1][i] == 'c' )
      c.twist(plus);
    if( argv[1][i] == 'C' )
      c.twist(minus);
    if( argv[1][i] == 'd' )
      d.twist(plus);
    if( argv[1][i] == 'D' )
      d.twist(minus);
    if( argv[1][i] == 'e' )
      e.twist(plus);
    if( argv[1][i] == 'E' )
      e.twist(minus);
    if( argv[1][i] == 'f' )
      f.twist(plus);
    if( argv[1][i] == 'F' )
      f.twist(minus);
    if( argv[1][i] == 'g' )
      g.twist(plus);
    if( argv[1][i] == 'G' )
      g.twist(minus);
    if( argv[1][i] == 'h' )
      h.twist(plus);
    if( argv[1][i] == 'H' )
      h.twist(minus);
  }
  
  M.snap_print(cout);
  return 0;
}
