#include <iostream.h>
#include <string.h>

#include "twister.h"

int main(int argc, char **argv)
{
  // gen21hyperelliptic.c

  // Code for generating hyperelliptic S_{2,1} bundles.  
  // Letters are a, A, b, B, c, C, d, D. 

  if (argc != 2)
  {
    cout << "Please specify a monodromy";
    cout << " in the letters 'a', 'A', ... , 'd', 'D'." << endl;
    return 1;
  }

  manifold M(argv[1]);

  square ac(M), bc(M), bd(M), xd(M);

  ac.closeup();
  bc.closeup();
  bd.closeup();
  xd.closeup();

  // Square graph -- the extra edges indicate the obvious gluings. 
  // Notice that x is a rectangle, not an annulus.
  //
  //     |
  //    -ac-  
  //     |   |
  //    -bc--bd-
  //     |   |
  //         xd
  //         |
  //

  annulus a(+ac);
  annulus b(+bc >> +bd);
  rectangle x(+xd);
  annulus c(-ac >> -bc);
  annulus d(-bd >> -xd);

  M.capoff(); 

  for( int i = 0; argv[1][i] != 0; i++ )
  {
    if( argv[1][i] == 'a' )
	a.twist(plus);
    if( argv[1][i] == 'A' )
	a.twist(minus);
    if( argv[1][i] == 'b' )
	b.twist(plus);
    if( argv[1][i] == 'B' )
	b.twist(minus);
    if( argv[1][i] == 'c' )
	c.twist(plus);
    if( argv[1][i] == 'C' )
	c.twist(minus);
    if( argv[1][i] == 'd' )
	d.twist(plus);
    if( argv[1][i] == 'D' )
	d.twist(minus);
  }

  M.snap_print(cout);
}
