#include <iostream.h>
#include <string.h>

#include "twister.h"

int main(int argc, char **argv)
{
  // gen21.c

  // Code for generating S_{2,1} bundles.  
  // Letters are abcdef and their capitals.  

  if (argc != 2)
  {
    cout << "Please specify a monodromy";
    cout << " in the letters 'a', 'A', ... , 'f', 'F'." << endl;
    return 1;
  }

  manifold M(argv[1]);

  square ab(M), cb(M), cd(M), fd(M), xd(M), ed(M);

  ab.closeup();
  cb.closeup();
  cd.closeup();
  fd.closeup();
  xd.closeup();
  ed.closeup();

  // Square graph -- the extra edges indicate the obvious gluings. 
  // Notice that x is a rectangle, not an annulus.
  //
  //     |
  //    -ab-  
  //     |   |
  //    -cb--cd-
  //     |   |
  //        -fd-
  //         |
  //         xd
  //         |
  //        -ed-
  //         |
  //

  annulus a(+ab);
  annulus c(+cb >> +cd);
  annulus f(+fd);
  rectangle x(+xd);
  annulus e(+ed);
  annulus b(-ab >> -cb);
  annulus d(-cd >> -fd >> -xd >> -ed);

  M.capoff(); 

  for( int i = 0; argv[1][i] != 0; i++ )
  {
    if( argv[1][i] == 'a' )
	a.twist(plus);
    if( argv[1][i] == 'A' )
	a.twist(minus);
    if( argv[1][i] == 'b' )
	b.twist(plus);
    if( argv[1][i] == 'B' )
	b.twist(minus);
    if( argv[1][i] == 'c' )
	c.twist(plus);
    if( argv[1][i] == 'C' )
	c.twist(minus);
    if( argv[1][i] == 'd' )
	d.twist(plus);
    if( argv[1][i] == 'D' )
	d.twist(minus);
    if( argv[1][i] == 'e' )
	e.twist(plus);
    if( argv[1][i] == 'E' )
	e.twist(minus);
    if( argv[1][i] == 'f' )
	f.twist(plus);
    if( argv[1][i] == 'F' )
	f.twist(minus);
  }

  M.snap_print(cout);
}
