#include <iostream.h>
#include <string.h>

#include "twister.h"  

int main(int argc, char **argv)
{
  // Program for generating genus two surface bundles 
  // over S^1, or genus two Heegaard splittings.
  // Uses the standard set of Dehn twist 
  // generators for the mapping class group.

  // Takes a word in letters aAbBcCdDeE at the command
  // line.  All other characters are silently ignored.
  // Optional argument forces a Heegaard splitting instead.

  char *name;

  if( argc == 1 )
  {
    name = "Trivial_Bundle";
  }
  else
  {
    name = argv[1];
  }

  manifold M(name);

  square s[4] = {square(M), square(M),
                 square(M), square(M)};

  // Intersection graph of curves:
  //
  //   a   e
  //   0   3
  //   b1c2d
  // 

  annulus a(+s[0]);
  annulus b(-s[0] >> +s[1]);
  annulus c(-s[1] >> +s[2]);
  annulus d(-s[2] >> +s[3]);
  annulus e(-s[3]);

  if( argc > 2 ) // make a Heegaard splitting.
  {
    a.twohandle(below); 
    e.twohandle(below); 
    b.twohandle(above); 
    d.twohandle(above); 
  }
  else            // make a surface bundle.
  {
    for( int i=0; i<4; i++ )
      s[i].closeup();
  }

  M.capoff();

  if( argc == 1 )
  { 
    M.snap_print(cout);
    return 0;
  }

  for( int i = 0; argv[1][i] != '\000'; i++ )
  {
    if (argv[1][i] == 'a')
      a.twist(plus);
    if (argv[1][i] == 'A')
      a.twist(minus);
    if (argv[1][i] == 'b')
      b.twist(plus);
    if (argv[1][i] == 'B')
      b.twist(minus);
    if (argv[1][i] == 'c')
      c.twist(plus);
    if (argv[1][i] == 'C')
      c.twist(minus);
    if (argv[1][i] == 'd')
      d.twist(plus);
    if (argv[1][i] == 'D')
      d.twist(minus);
    if (argv[1][i] == 'e')
      e.twist(plus);
    if (argv[1][i] == 'E')
      e.twist(minus);
  }

  M.snap_print(cout);
  return 0;
}
