#include <iostream.h>
#include <string.h>

#include "twister.h"  

int main(int argc, char **argv)
{
  // gen12Birman.c  
  // 
  // Program for generating bundles where 
  // 1. the fibre is a twice holed and
  // 2. there are two cusps and
  // 3. the monodromy lies in the Birman subgroup.

  // Takes a word in letters xXyY at the command
  // line.  All other characters are silently ignored.
  // Optional argument is used as the name of the manifold
  // produced.

  char *name;

  if( argc == 1 )
  {
    name = "Trivial Bundle";
  }
  if( argc == 2 )
  {
    name = argv[1];
  }
  else
  {
    name = argv[2];
  }

  manifold M(name);

  square s[6] = {square(M), square(M),
		 square(M), square(M),
		 square(M), square(M)};

  for (int i=0; i<6; i++)
  {
    s[i].closeup();
  }

  // Intersection graph of curves:
  //
  // There are four curves, in two pairs of two.  These give two 
  // elements of the Birman subgroup -- I think these generate.   
  // (Each pair cuts the surface into two pants.)
  //

  rectangle x(-s[5] >> -s[4]);
  annulus a(+s[0] >> +s[1]);
  annulus b(-s[2] >> -s[3] >> +s[4]);
  annulus c(-s[1] >> +s[2]);
  annulus d(-s[0] >> +s[3] >> +s[5]);

  M.capoff();

  if( argc == 1 )
  { 
    M.snap_print(cout);
    return 0;
  }

  for( int i = 0; argv[1][i] != '\000'; i++ )
  {
    if (argv[1][i] == 'x')
    {
      a.twist(plus);
      b.twist(minus);
    }
    if (argv[1][i] == 'X')
    {
      b.twist(plus);
      a.twist(minus);
    }
    if (argv[1][i] == 'y')
    {
      c.twist(plus);
      d.twist(minus);
    }
    if (argv[1][i] == 'Y')
    {
      d.twist(plus);
      c.twist(minus);
    }
  }
  
  M.snap_print(cout);
  return 0;
}
