#include <iostream.h>
#include <string.h>

#include "twister.h"  

int main(int argc, char **argv)
{
  // gen12.c  
  // 
  // Program for generating bundles where 
  // 1. the fibre is a twice holed torus and
  // 2. there are two cusps.

  // Uses the standard set of Dehn twist 
  // generators for the mapping class group, abc.

  // Takes a word in letters aAbBcCdD at the command line.  (Here d is
  // the twist about the boundary of the regular neighborhood of the
  // union b \cup c.  Also, abc generate the pure mapping class
  // group.)  All other characters are silently ignored.  Optional
  // argument is used as the name of the manifold produced.

  char *name;

  if( argc == 1 )
  {
    name = "Trivial Bundle";
  }
  if( argc == 2 )
  {
    name = argv[1];
  }
  else
  {
    name = argv[2];
  }

  manifold M(name);

  square s[3] = {square(M), square(M),
                 square(M)};

  for (int i=0; i<3; i++)
  {
    s[i].closeup();
  }

  // Intersection graph of curves:
  //
  //    0   1   2
  //  x---a---b---c
  // 

  rectangle x(-s[0]);
  annulus a(+s[0] >> +s[1]);
  annulus b(-s[1] >> +s[2]);
  annulus c(-s[2]);

  M.capoff();

  if( argc == 1 )
  { 
    M.snap_print(cout);
    return 0;
  }

  for( int i = 0; argv[1][i] != '\000'; i++ )
  {
    if (argv[1][i] == 'a')
      a.twist(plus);
    if (argv[1][i] == 'A')
      a.twist(minus);
    if (argv[1][i] == 'b')
      b.twist(plus);
    if (argv[1][i] == 'B')
      b.twist(minus);
    if (argv[1][i] == 'c')
      c.twist(plus);
    if (argv[1][i] == 'C')
      c.twist(minus);
    
    // We will also allow the user to specify twists on 
    // the boundary of the regular neighborhood of $b \cup c$. 
    
    if (argv[1][i] == 'd')
    {
      b.twist(plus);
      c.twist(plus);
      b.twist(plus);
      c.twist(plus);
      b.twist(plus);
      c.twist(plus);
    }
    if (argv[1][i] == 'D')
    {
      c.twist(minus);
      b.twist(minus);
      c.twist(minus);
      b.twist(minus);
      c.twist(minus);
      b.twist(minus);
    }
  }
  
  M.snap_print(cout);
  return 0;
}
