// gen11.c  
// 
// Program for generating once punctured torus bundles.
// Uses the standard set of Dehn twist 
// generators for the mapping class group.

// Takes a word in letters aAbB at the command
// line.  All other characters are silently ignored.
// Optional argument is used as the name of the manifold
// produced.
//
// Example: Ab will produce the figure eight knot complement.

#include <iostream.h>
#include <string.h>

#include "twister.h"  

int main(int argc, char **argv)
{
  char *name;

  if( argc == 1 )
  {
    name = "Trivial Bundle";
  }
  if( argc == 2 )
  {
    name = argv[1];
  }
  else
  {
    name = argv[2];
  }

  manifold M(name);

  square s[2] = {square(M), square(M)};

  for (int i=0; i<2; i++)
  {
    s[i].closeup();
  }

  // A sketch of the surface:
  //
  //       |
  // -xa---ab-
  //       |
  //
  // The intersection graph:
  // 
  //    0   1  
  //  x---a---b
  // 

  rectangle x(-s[0]);
  annulus a(+s[0] >> +s[1]);
  annulus b(-s[1]);

  M.capoff();

  if( argc == 1 )
  { 
    M.snap_print(cout);
    return 0;
  }

  for( int i = 0; argv[1][i] != '\000'; i++ )
  {
    if (argv[1][i] == 'a')
      a.twist(plus);
    if (argv[1][i] == 'A')
      a.twist(minus);
    if (argv[1][i] == 'b')
      b.twist(plus);
    if (argv[1][i] == 'B')
      b.twist(minus);
  }
  
  M.snap_print(cout);
  return 0;
}
