#include <iostream.h>

#include "twister.h"

int main(int argc, char **argv)
{
  char *name;

  if( argc == 1 )
  {
    name = "Three_Torus";
  }
  else
  {
    name = argv[1];
  }

  manifold M(name);

  square s(M);

  // Intersection graph of curves:
  //
  //     a-b
  // 

  annulus a(+s);
  annulus b(-s);

  if( argc > 2 ) // make a Heegaard splitting.
  {
    a.twohandle(below); 
    b.twohandle(above); 
  }
  else            // make a torus bundle.
  {
    s.closeup();
  }

  M.capoff();

  if( argc == 1 )
  { 
    M.snap_print(cout);
    return 0;
  }

  for( int i = 0; argv[1][i] != '\000'; i++ )
  {
    if( argv[1][i] == 'a' )
      a.twist(plus);
    if( argv[1][i] == 'A' )
      a.twist(minus);
    if( argv[1][i] == 'b' )
      b.twist(plus);
    if( argv[1][i] == 'B' )
      b.twist(minus);
  }

  M.snap_print(cout);
  return 0;
}


